const fs = require('fs')
const path = require('path')
const { execSync } = require('child_process')

console.log('🚀 Building FiveM UDG V5.0 for production...')

try {
  // Build the project
  console.log('📦 Building Next.js application...')
  execSync('npm run build', { stdio: 'inherit' })
  
  // Create deployment info
  const deployInfo = {
    buildTime: new Date().toISOString(),
    version: '5.0.0',
    environment: 'production'
  }
  
  fs.writeFileSync('deploy-info.json', JSON.stringify(deployInfo, null, 2))
  
  console.log('✅ Build completed successfully!')
  console.log('📋 Next steps for cPanel deployment:')
  console.log('1. Upload all files to your hosting')
  console.log('2. Set up Node.js app in cPanel')
  console.log('3. Configure environment variables')
  console.log('4. Start the application')
  
} catch (error) {
  console.error('❌ Build failed:', error.message)
  process.exit(1)
}