# 🚀 FiveM UDG V5.0 - cPanel Installation

## 📦 Files Ready for Upload

Folder `deployment-package` berisi semua file yang dibutuhkan:
- ✅ Built application (.next folder)
- ✅ Server configuration (server.js)
- ✅ Database scripts (scripts folder)
- ✅ Environment template (.env.local)

## 🔧 Installation Steps

### 1. **Upload ke cPanel**
```
1. Compress folder 'deployment-package' menjadi ZIP
2. Upload via File Manager ke public_html
3. Extract semua files
```

### 2. **Setup Node.js App**
```
cPanel → Node.js Apps → Create App:
- App Root: /public_html/deployment-package
- App URL: yourdomain.com
- Startup File: server.js
- Node.js Version: 18+
```

### 3. **Install Dependencies**
```bash
# Di Terminal cPanel:
cd public_html/deployment-package
npm install --production
```

### 4. **Environment Variables**
Edit file `.env.local`:
```env
NEXT_PUBLIC_SUPABASE_URL=https://your-project.supabase.co
NEXT_PUBLIC_SUPABASE_ANON_KEY=your_anon_key_here
NODE_ENV=production
```

### 5. **Database Setup**
```sql
-- Di Supabase SQL Editor, jalankan:
-- 1. scripts/create-database-schema.sql
-- 2. scripts/create-rls-policies.sql
```

### 6. **Start Application**
```
cPanel → Node.js Apps → Restart App
```

## ✅ Verification

Buka domain Anda, seharusnya FiveM UDG Panel sudah running!

## 🆘 Troubleshooting

**Error "Module not found":**
```bash
npm install --production --force
```

**Port Error:**
Pastikan server.js menggunakan `process.env.PORT`

**SSL Required:**
Aktifkan SSL Certificate di cPanel

## 📞 Support
Discord: discord.gg/A3dEYdqnyK