import { createClient } from '@supabase/supabase-js'

const supabaseUrl = process.env.NEXT_PUBLIC_SUPABASE_URL!
const supabaseAnonKey = process.env.NEXT_PUBLIC_SUPABASE_ANON_KEY!

export const supabase = createClient(supabaseUrl, supabaseAnonKey)

// Database Types
export interface Database {
  public: {
    Tables: {
      users: {
        Row: {
          id: string
          username: string
          email: string
          avatar?: string
          join_date: string
          total_upvotes: number
          total_servers: number
          plan: 'free' | 'premium' | 'enterprise'
          favorite_servers: string[]
          last_active: string
          country: string
          verified: boolean
          api_key?: string
          created_at: string
          updated_at: string
        }
        Insert: {
          id?: string
          username: string
          email: string
          avatar?: string
          join_date?: string
          total_upvotes?: number
          total_servers?: number
          plan?: 'free' | 'premium' | 'enterprise'
          favorite_servers?: string[]
          last_active?: string
          country?: string
          verified?: boolean
          api_key?: string
          created_at?: string
          updated_at?: string
        }
        Update: {
          id?: string
          username?: string
          email?: string
          avatar?: string
          join_date?: string
          total_upvotes?: number
          total_servers?: number
          plan?: 'free' | 'premium' | 'enterprise'
          favorite_servers?: string[]
          last_active?: string
          country?: string
          verified?: boolean
          api_key?: string
          created_at?: string
          updated_at?: string
        }
      }
      servers: {
        Row: {
          id: string
          hostname: string
          clients: number
          sv_maxclients: number
          mapname: string
          gametype: string
          upvote_power: number
          country: string
          language: string
          tags: string[]
          resources: string[]
          variables: Record<string, any>
          connect_endpoints: string[]
          owner_profile: any
          last_seen: string
          premium: boolean
          burst: boolean
          fallback: boolean
          private: boolean
          locale_country: string
          hostname_locale: string
          icon: string
          banner: string
          description: string
          website: string
          discord: string
          uptime: number
          avg_players: number
          max_players_record: number
          rating: number
          reviews: number
          categories: string[]
          mods: string[]
          scripts: string[]
          onesync: boolean
          enforce_game_build: string
          pure_level: number
          license_key_token: string
          last_ping?: number
          response_time?: number
          server_load?: number
          memory_usage?: number
          cpu_usage?: number
          created_at: string
          updated_at: string
        }
        Insert: {
          id: string
          hostname: string
          clients?: number
          sv_maxclients?: number
          mapname?: string
          gametype?: string
          upvote_power?: number
          country?: string
          language?: string
          tags?: string[]
          resources?: string[]
          variables?: Record<string, any>
          connect_endpoints?: string[]
          owner_profile?: any
          last_seen?: string
          premium?: boolean
          burst?: boolean
          fallback?: boolean
          private?: boolean
          locale_country?: string
          hostname_locale?: string
          icon?: string
          banner?: string
          description?: string
          website?: string
          discord?: string
          uptime?: number
          avg_players?: number
          max_players_record?: number
          rating?: number
          reviews?: number
          categories?: string[]
          mods?: string[]
          scripts?: string[]
          onesync?: boolean
          enforce_game_build?: string
          pure_level?: number
          license_key_token?: string
          last_ping?: number
          response_time?: number
          server_load?: number
          memory_usage?: number
          cpu_usage?: number
          created_at?: string
          updated_at?: string
        }
        Update: {
          id?: string
          hostname?: string
          clients?: number
          sv_maxclients?: number
          mapname?: string
          gametype?: string
          upvote_power?: number
          country?: string
          language?: string
          tags?: string[]
          resources?: string[]
          variables?: Record<string, any>
          connect_endpoints?: string[]
          owner_profile?: any
          last_seen?: string
          premium?: boolean
          burst?: boolean
          fallback?: boolean
          private?: boolean
          locale_country?: string
          hostname_locale?: string
          icon?: string
          banner?: string
          description?: string
          website?: string
          discord?: string
          uptime?: number
          avg_players?: number
          max_players_record?: number
          rating?: number
          reviews?: number
          categories?: string[]
          mods?: string[]
          scripts?: string[]
          onesync?: boolean
          enforce_game_build?: string
          pure_level?: number
          license_key_token?: string
          last_ping?: number
          response_time?: number
          server_load?: number
          memory_usage?: number
          cpu_usage?: number
          created_at?: string
          updated_at?: string
        }
      }
      analytics: {
        Row: {
          id: string
          user_id: string
          server_id: string
          timestamp: string
          upvotes: number
          speed: number
          duration: number
          success: boolean
          type: 'upvote' | 'powerboost'
          created_at: string
        }
        Insert: {
          id?: string
          user_id: string
          server_id: string
          timestamp?: string
          upvotes?: number
          speed?: number
          duration?: number
          success?: boolean
          type?: 'upvote' | 'powerboost'
          created_at?: string
        }
        Update: {
          id?: string
          user_id?: string
          server_id?: string
          timestamp?: string
          upvotes?: number
          speed?: number
          duration?: number
          success?: boolean
          type?: 'upvote' | 'powerboost'
          created_at?: string
        }
      }
      favorites: {
        Row: {
          id: string
          server_id: string
          user_id: string
          name: string
          address: string
          players: number
          max_players: number
          added_at: string
          last_checked: string
          status: 'online' | 'offline'
          ping: number
          created_at: string
        }
        Insert: {
          id?: string
          server_id: string
          user_id: string
          name: string
          address: string
          players?: number
          max_players?: number
          added_at?: string
          last_checked?: string
          status?: 'online' | 'offline'
          ping?: number
          created_at?: string
        }
        Update: {
          id?: string
          server_id?: string
          user_id?: string
          name?: string
          address?: string
          players?: number
          max_players?: number
          added_at?: string
          last_checked?: string
          status?: 'online' | 'offline'
          ping?: number
          created_at?: string
        }
      }
    }
  }
}
