@echo off
echo 🚀 Creating FiveM UDG V5.0 deployment package...

REM Create deployment folder
mkdir deployment-package 2>nul

REM Copy essential files
echo 📦 Copying files...
xcopy /E /I /Y .next deployment-package\.next
xcopy /E /I /Y public deployment-package\public
xcopy /E /I /Y scripts deployment-package\scripts
xcopy /Y package.json deployment-package\
xcopy /Y server.js deployment-package\
xcopy /Y next.config.mjs deployment-package\
xcopy /Y .env.local deployment-package\
xcopy /Y CPANEL-SETUP.md deployment-package\

REM Create package.json for production
echo { > deployment-package\package-production.json
echo   "name": "fivem-udg-v5", >> deployment-package\package-production.json
echo   "version": "5.0.0", >> deployment-package\package-production.json
echo   "scripts": { >> deployment-package\package-production.json
echo     "start": "node server.js" >> deployment-package\package-production.json
echo   }, >> deployment-package\package-production.json
echo   "dependencies": { >> deployment-package\package-production.json
echo     "next": "^14.2.16", >> deployment-package\package-production.json
echo     "@supabase/supabase-js": "^2.39.3", >> deployment-package\package-production.json
echo     "@supabase/auth-helpers-nextjs": "^0.10.0" >> deployment-package\package-production.json
echo   } >> deployment-package\package-production.json
echo } >> deployment-package\package-production.json

echo ✅ Deployment package created in 'deployment-package' folder
echo 📋 Next steps:
echo 1. Compress 'deployment-package' folder
echo 2. Upload to your cPanel hosting
echo 3. Follow CPANEL-SETUP.md guide
pause